function Upper_tuning_requirement =Upper_Level_Tuning_Light(data,level_pts,BSL,BSR,dI_array,I_PDC,min_thresh)

levels=size(level_pts,1);
mean_I_store=zeros(1,1);
max_count=1;

padded_level_I_Fit=[BSL;dI_array';BSR];

for i=1:levels-1
    
    if level_pts(i)>0 && level_pts(i+1)>level_pts(i) && abs(level_pts(i+1)-level_pts(i))>3 %there should be at least 3 data points for a minimum to exist
    
    previosu_mean=padded_level_I_Fit(i);
    current_mean=padded_level_I_Fit(i+1);
    next_mean=padded_level_I_Fit(i+2);
    
        if current_mean>previosu_mean && current_mean>next_mean
            %we are in a peak and no need to do lower level evaluations
            mean_I_store(max_count)=0>1;%to induce a false logic zero 
            max_count=max_count+1;
        else
            level_data=data(level_pts(i):level_pts(i+1));
            [~,pos]=findpeaks(level_data,'MinPeakHeight',I_PDC);%the negative inverts the data. Thus minimas become maximas and vice versa

            threshold=dI_array(i)+(min_thresh);
            total_peaks=length(pos);

            for j=1:total_peaks
                max_pos=pos(j);
                max_I=level_data(max_pos);
                mean_I_store(max_count)=max_I>threshold;
                max_count=max_count+1;
            end
        end
    else
       mean_I_store(max_count)=0>1;%to induce a false logic zero 
       max_count=max_count+1;
    end
    
end

    Upper_tuning_requirement=sum(mean_I_store);
end